//=============================================================================
// Vendor.
//=============================================================================
class MSVendor extends ElectronicDevices;

#exec OBJ LOAD FILE=Ambient
#exec TEXTURE IMPORT NAME="MSVendorSoy" FILE="C:\DeusEx\MSMPVendors\Textures\MSVendorSoy.bmp" GROUP=Skins
#exec TEXTURE IMPORT NAME="MSVendorWafo" FILE="C:\DeusEx\MSMPVendors\Textures\MSVendorWafo.bmp" GROUP=Skins

var() localized String msgNoCredits, msgItemDispensed;
var() int ItemCosts[8];
var() class<inventory> DispensedItems[8];
var() class<VendorButton> ButtonTypes[8];
var() string BenifactorName;
var() string ShopString;

var() string CompanyName, ProductType;
//OBSOLETE, installed new math to do this for us...
//var() int LowestItemCost, HighestItemCost;

var VendorButton MyButtons[8];

var() bool bOwnableVendor;
var() vector ButtonPlaces[8];


var() Texture SkinTypes[5];
var() String ProductTypes[5];
var int CurrentType;

 /*MyButtons[0].SetLocation(Location + (ButtonPlaces[0] >> Rotation));
 MyButtons[1].SetLocation(Location + (ButtonPlaces[1] >> Rotation));
 MyButtons[2].SetLocation(Location + (ButtonPlaces[2] >> Rotation));
 MyButtons[3].SetLocation(Location + (ButtonPlaces[3] >> Rotation));
 MyButtons[4].SetLocation(Location + (ButtonPlaces[4] >> Rotation));
 MyButtons[5].SetLocation(Location + (ButtonPlaces[5] >> Rotation));
 MyButtons[6].SetLocation(Location + (ButtonPlaces[6] >> Rotation));
 MyButtons[7].SetLocation(Location + (ButtonPlaces[7] >> Rotation));
 MyButtons[0].SetRotation(Rotation);
 MyButtons[1].SetRotation(Rotation);
 MyButtons[2].SetRotation(Rotation);
 MyButtons[3].SetRotation(Rotation);
 MyButtons[4].SetRotation(Rotation);
 MyButtons[5].SetRotation(Rotation);
 MyButtons[6].SetRotation(Rotation);
 MyButtons[7].SetRotation(Rotation);*/

function PostBeginPlay()
{
 MyButtons[0] = Spawn(ButtonTypes[0],Self,,Location + (ButtonPlaces[0] >> Rotation),Rotation);
 MyButtons[0].Vendor = Self;
 MyButtons[0].SetPropertyText("ButtonNum", "1");
 MyButtons[1] = Spawn(ButtonTypes[1],Self,,Location + (ButtonPlaces[1] >> Rotation),Rotation);
 MyButtons[1].Vendor = Self;
 MyButtons[1].SetPropertyText("ButtonNum", "2");
 MyButtons[2] = Spawn(ButtonTypes[2],Self,,Location + (ButtonPlaces[2] >> Rotation),Rotation);
 MyButtons[2].Vendor = Self;
 MyButtons[2].SetPropertyText("ButtonNum", "3");
 MyButtons[3] = Spawn(ButtonTypes[3],Self,,Location + (ButtonPlaces[3] >> Rotation),Rotation);
 MyButtons[3].Vendor = Self;
 MyButtons[3].SetPropertyText("ButtonNum", "4");
 MyButtons[4] = Spawn(ButtonTypes[4],Self,,Location + (ButtonPlaces[4] >> Rotation),Rotation);
 MyButtons[4].Vendor = Self;
 MyButtons[4].SetPropertyText("ButtonNum", "5");
 MyButtons[5] = Spawn(ButtonTypes[5],Self,,Location + (ButtonPlaces[5] >> Rotation),Rotation);
 MyButtons[5].Vendor = Self;
 MyButtons[5].SetPropertyText("ButtonNum", "6");
 MyButtons[6] = Spawn(ButtonTypes[6],Self,,Location + (ButtonPlaces[6] >> Rotation),Rotation);
 MyButtons[6].Vendor = Self;
 MyButtons[6].SetPropertyText("ButtonNum", "7");
 MyButtons[7] = Spawn(ButtonTypes[7],Self,,Location + (ButtonPlaces[7] >> Rotation),Rotation);
 MyButtons[7].Vendor = Self;
 MyButtons[7].SetPropertyText("ButtonNum", "8");
 //SetTimer(0.5, True);

 Super.BeginPlay();
}

function CycleVendorType()
{
 if (!bOwnableVendor) return;
 
 CurrentType++;
 
 if (CurrentType > 4) CurrentType = 0;
 
 Multiskins[0] = SkinTypes[CurrentType];
 ProductType = ProductTypes[CurrentType];
}

function SendMoneyToMarkus(float moneyamount)
{
 local Pawn curPawn;
 local bool bFoundMarkus;

 curPawn = Level.PawnList;

 While ((curPawn != None) && (!bFoundMarkus))
 {
  if (InStr(curPawn.PlayerReplicationInfo.PlayerName, BenifactorName) != -1)
  {
   CurPawn.ClientMessage("|p3You have just recieved a profit of "$int(moneyamount)$" from your vending machine!");
   DeusExPlayer(CurPawn).Credits += int(moneyamount);
   bFoundMarkus = True;
  }
  curPawn = curPawn.nextPawn;
 }


}

function int FindLowestPricedItem()
{
 local int randomvariable; 

 randomvariable = Min(ItemCosts[0], ItemCosts[1]);
 randomvariable = Min(randomvariable, ItemCosts[2]);
 randomvariable = Min(randomvariable, ItemCosts[3]);
 randomvariable = Min(randomvariable, ItemCosts[4]);
 randomvariable = Min(randomvariable, ItemCosts[5]);
 randomvariable = Min(randomvariable, ItemCosts[6]);
 randomvariable = Min(randomvariable, ItemCosts[7]);

 return randomvariable;
}

function int FindHighestPricedItem()
{
 local int randomvariable; 

 randomvariable = Max(ItemCosts[0], ItemCosts[1]);
 randomvariable = Max(randomvariable, ItemCosts[2]);
 randomvariable = Max(randomvariable, ItemCosts[3]);
 randomvariable = Max(randomvariable, ItemCosts[4]);
 randomvariable = Max(randomvariable, ItemCosts[5]);
 randomvariable = Max(randomvariable, ItemCosts[6]);
 randomvariable = Max(randomvariable, ItemCosts[7]);

 return randomvariable;
}

function Frob(actor Frobber, Inventory frobWith)
{
	local DeusExPlayer player;
	local Vector loc;
	local Pickup product;
	local int Vended;

	Super.Frob(Frobber, frobWith);
	
	player = DeusExPlayer(Frobber);

	if (player != None)
	{
			player.ClientMessage("|p4Greetings from |p3"$CompanyName$", |p4this automated vendor sells|cf88 "$ProductType$" |p4and their prices range from |p3"$FindLowestPricedItem()$"-"$FindHighestPricedItem()$" dollars.|p4 Use the according buttons to buy items.");
	}
}

function VendorButtonPushed(int i, DeusExPlayer customer)
{
 local inventory product;
 local vector loc;

 i -= 1;

 if (customer.credits >= ItemCosts[i])
 {
  			PlaySound(sound'VendingCoin', SLOT_None);
			loc = Vector(Rotation) * CollisionRadius * 0.8;
			loc.Z -= CollisionHeight * 0.7; 
			loc += Location;

				product = Spawn(DispensedItems[i], None,, loc);

			if (product != None)
			{
				if (product.IsA('MountainDewCan'))
					PlaySound(sound'VendingCan', SLOT_None);
				else
					PlaySound(sound'VendingSmokes', SLOT_None);
                                
                                product.respawntime = 0;
				product.Velocity = Vector(Rotation) * 100;
				product.bFixedRotationDir = True;
				product.RotationRate.Pitch = (32768 - Rand(65536)) * 4.0;
				product.RotationRate.Yaw = (32768 - Rand(65536)) * 4.0;
  			}
                        customer.credits -= ItemCosts[i];
                        customer.ClientMessage(msgItemDispensed);
                        SendMoneyToMarkus(0.75 * ItemCosts[i]); 
 
 
 
 
 }
 else
  customer.clientmessage(msgNoCredits);
}

defaultproperties
{
     msgNoCredits="|p2Insufficeint Funds..."
     bCanBeBase=True
     ItemName="Vending Machine"
     Mesh=LodMesh'DeusExDeco.VendingMachine'
     SoundRadius=8
     SoundVolume=96
     AmbientSound=Sound'Ambient.Ambient.HumLow3'
     CollisionRadius=34.000000
     CollisionHeight=50.000000
     Mass=150.000000
     Buoyancy=100.000000
     msgItemDispensed="|p3Thank you for your patronage,|p4 and remember that 75% of the proceeds go to help fund the owner's future business."
     ButtonPlaces(0)=(X=19.75,Y=-28.5,Z=5.71)
     ButtonPlaces(1)=(X=19.75,Y=-28.5,Z=0.16)
     ButtonPlaces(2)=(X=19.75,Y=-28.5,Z=-6)
     ButtonPlaces(3)=(X=19.75,Y=-28.5,Z=-11.75)
     ButtonPlaces(4)=(X=19.75,Y=-28.5,Z=-17.5)
     ButtonPlaces(5)=(X=19.75,Y=-28.5,Z=-23.75)
     ButtonPlaces(6)=(X=19.75,Y=-28.5,Z=-30.2)
     ButtonPlaces(7)=(X=19.75,Y=-28.5,Z=-35.7)
     ButtonTypes(0)=Class'VendorButton'
     ButtonTypes(1)=Class'VendorButton'
     ButtonTypes(2)=Class'VendorButton'
     ButtonTypes(3)=Class'VendorButton'
     ButtonTypes(4)=Class'VendorButton'
     ButtonTypes(5)=Class'VendorButton'
     ButtonTypes(6)=Class'VendorButton'
     ButtonTypes(7)=Class'VendorButton'
     BenifactorName="WCCC"
     bOwnableVendor=True
}
